IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CPJ_BalanceCC_Rpt') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CPJ_BalanceCC_Rpt
END
GO

CREATE PROCEDURE [dbo].[CPJ_BalanceCC_Rpt]	@pJson VARCHAR(8000)
AS
SET NOCOUNT ON

/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug			    	TINYINT
DECLARE @pId_Usuario			    SMALLINT
DECLARE @pFecha_Desde			    DATETIME
DECLARE @pFecha_Hasta			    DATETIME
DECLARE @pId_Centro_Costo			CHAR(10)
DECLARE @pId_Alias_Cta_Cont			SMALLINT
DECLARE @pId_Plan_Cta			    INT
DECLARE @pId_Unid_Negocio			CHAR(10)
DECLARE @pSoloResultado	    		TINYINT			--10/05/2021

SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pFecha_Desde				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde')), '19000101')
SET @pFecha_Hasta				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta')), '19000101')
SET @pId_Centro_Costo			= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Centro_Costo')), '')
SET @pId_Alias_Cta_Cont			= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Alias_Cta_Cont')), 0)
SET @pId_Plan_Cta				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Plan_Cta')), 0)
SET @pId_Unid_Negocio			= ISNULL(CONVERT(CHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Unid_Negocio')), '')
SET @pSoloResultado				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'SoloResultado')), 0)
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variables Locales*/
DECLARE @SqlStr						NVARCHAR(MAX)
DECLARE @Id_Trans					INT
DECLARE @Alias						DECIMAL(12,0)
DECLARE @Nro_Cta_Contable			VARCHAR(20)
DECLARE @Debe						DECIMAL(12,2)
DECLARE @Haber						DECIMAL(12,2)
DECLARE @Fecha						DATETIME
DECLARE @Descripcion				VARCHAR(80)
DECLARE @Centro_Costo				VARCHAR(200)
DECLARE @Centro_Costo_Padre1		VARCHAR(200)
DECLARE @Centro_Costo_Padre2		VARCHAR(200)
DECLARE @Destinatario				VARCHAR(100)
DECLARE @Observacion_Orig			VARCHAR(8000)
DECLARE @Observacion_Dest			VARCHAR(8000)
DECLARE @Importe					DECIMAL(12,2)
DECLARE @Imp_Total_Fac				DECIMAL(12,2)
DECLARE @Imp_Aplicado				DECIMAL(12,2)
DECLARE @Imp_Fac					DECIMAL(12,2)
DECLARE @Coef_Aplic					DECIMAL(12,2)
DECLARE @Id_Trans_CCC				INT
DECLARE @Id_Centro_Costo_Padre1		CHAR(10)
DECLARE @Id_Centro_Costo_Padre2		CHAR(10)
DECLARE @Mes_Desde					DATETIME
DECLARE @Mes_Hasta					DATETIME
DECLARE @Mes_Nro					TINYINT
DECLARE @Suma_Debe					DECIMAL(16,2)
DECLARE @Suma_Haber					DECIMAL(16,2)
DECLARE @Suma_Saldo					DECIMAL(16,2)
DECLARE @Id_Centro_Costo			CHAR(10)
/*FIN Variables Locales*/

BEGIN TRY
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_BalanceCC_Rpt'
		PRINT 'Parametros: '
		PRINT '@pId_Usuario: ' + CONVERT(VARCHAR(10), @pId_Usuario) + '. @pFecha_Desde: ' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + '. @pFecha_Hasta: ' + CONVERT(VARCHAR(10), @pFecha_Hasta, 112) + '. @pId_Centro_Costo: ' + CONVERT(VARCHAR(10), @pId_Centro_Costo)
	END

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END
	
	IF(@pFecha_Desde = '19000101')								RAISERROR ('Fecha_Desde can not be blank.', 16,  1)
	IF(@pFecha_Hasta = '19000101')								RAISERROR ('Fecha_Hasta can not be blank.', 16,  1) 
	IF(@pFecha_Desde >= @pFecha_Hasta)							RAISERROR ('Fecha_Desde can not be bigger or equal than Fecha_Hasta.', 16,  1) 
	IF(DATEDIFF(YEAR, @pFecha_Desde, @pFecha_Hasta) > 0)		RAISERROR ('Diference between Fecha_Desde and Fecha_Hasta can not be bigger than a year.', 16,  1) 	
	IF(@pId_Centro_Costo = '')									RAISERROR ('ID_Centro_Costo can not be blank.', 16,  1)
	
	/*=============================================================================================================================*/

	SELECT
	@Centro_Costo = ISNULL(Descripcion, ''),
	@Id_Centro_Costo_Padre1 = ISNULL(Id_Centro_Costo_Padre, '')
	FROM Centro_Costos
	WHERE
	Id_Centro_Costo = @pId_Centro_Costo

	SELECT
	@Centro_Costo_Padre1 = ISNULL(Descripcion, ''),
	@Id_Centro_Costo_Padre2 = ISNULL(Id_Centro_Costo_Padre, '')
	FROM Centro_Costos
	WHERE
	Id_Centro_Costo = @Id_Centro_Costo_Padre1

	SELECT
	@Centro_Costo_Padre2 = ISNULL(Descripcion, '')
	FROM Centro_Costos
	WHERE
	Id_Centro_Costo = @Id_Centro_Costo_Padre2

	/*=============================================================================================================================*/
	
	CREATE TABLE #Rpt_BalanceCC
	(
	Id_Trans_O						INT,
	Id_Trans_D						INT,
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Saldo							DECIMAL(12,2),
	Fecha							DATETIME,
	Cta_Contable					VARCHAR(80),
	Id_Centro_Costo					VARCHAR(10),
	Centro_Costo					VARCHAR(200),
	Centro_Costo2					VARCHAR(200),
	Centro_Costo3					VARCHAR(200),
	Destinatario					VARCHAR(100),
	Observacion_Orig				VARCHAR(8000),
	Observacion_Dest				VARCHAR(8000)
	)

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Recibos Varios'
	END

	CREATE TABLE #Rpt_BalanceCC_Recibos_Varios
	(
	Id_Trans						INT,
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Fecha							DATETIME,
	Descripcion						VARCHAR(80),
	Destinatario					VARCHAR(100),
	Observacion_Orig				VARCHAR(8000),
	Observacion_Dest				VARCHAR(8000)
	)

	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_BalanceCC_Recibos_Varios (Id_Trans, Alias, Nro_Cta_Contable, Debe, Haber, Fecha, Descripcion, Destinatario, Observacion_Orig, Observacion_Dest) '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))							+ CHAR(13) + 
					'SELECT '										+ CHAR(13) + 
					'C.Id_Trans, '									+ CHAR(13) + 
					'O.Alias, '										+ CHAR(13) +
					'O.Nro_Cta_Contable, '							+ CHAR(13) + 
					'C.Debe, '										+ CHAR(13) + 
					'C.Haber, '										+ CHAR(13) + 
					'E.Fecha, '										+ CHAR(13) + 
					'O.Descripcion AS Cta_Contable, '				+ CHAR(13) + 
					'ISNULL(E.Destinatario, '''') AS Destinatario, '	+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), E.Observacion), '''') AS Observacion_Orig, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), E.Observacion), '''') AS Observacion_Dest '+ CHAR(13) +
					'FROM Cbtes_Ctas_Contables C, Cbtes E,Cbtes_Tipos T,Pla_Ctas_Cuentas_Contables O ' + CHAR(13) + 
					'WHERE '										+ CHAR(13) + 
					'C.Id_Trans = E.Id_Trans '						+ CHAR(13) + 
					'AND E.Id_Tipo_Cbte = T.Id_Tipo_Cbte '			+ CHAR(13) + 					
					'AND ISNULL(E.Id_Cliente, 0) = 0 '				+ CHAR(13) + 
					'AND O.Id_Cta_Contable = C.Id_Cta_Contable '	+ CHAR(13) +
					'AND E.Id_Estado_Cbte NOT IN (0,3) '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND E.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND E.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND C.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND T.Compromete_Recibos IN (1,-1)'

	IF(@pSoloResultado = 1)
	BEGIN
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND ISNULL(O.Tipo, '''') IN (''+'',''-'') '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr (Recibos Varios): '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	/*=============================================================================================================================*/

	DECLARE cur_BalanceCC_Recibos_Varios CURSOR FOR
	SELECT 
	Id_Trans,
	Alias,
	Nro_Cta_Contable, 
	Debe, 
	Haber, 
	Fecha, 
	Descripcion,
	Destinatario,
	Observacion_Orig,
	Observacion_Dest
	FROM #Rpt_BalanceCC_Recibos_Varios

	OPEN cur_BalanceCC_Recibos_Varios
	FETCH NEXT FROM cur_BalanceCC_Recibos_Varios INTO @Id_Trans, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	WHILE @@FETCH_STATUS = 0
	BEGIN

		INSERT INTO #Rpt_BalanceCC
		(Id_Trans_O,
		Id_Trans_D,
		Alias,
		Nro_Cta_Contable,
		Debe,
		Haber,
		Saldo,
		Fecha,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Centro_Costo2,
		Centro_Costo3,
		Destinatario,
		Observacion_Orig,
		Observacion_Dest)
		VALUES
		(@Id_Trans,
		0,
		@Alias,
		@Nro_Cta_Contable,
		@Debe,
		@Haber,
		0,
		@Fecha,
		@Descripcion,
		@pId_Centro_Costo,
		@Centro_Costo,
		@Centro_Costo_Padre1,
		@Centro_Costo_Padre2,
		@Destinatario,
		@Observacion_Orig,
		@Observacion_Dest)

		FETCH NEXT FROM cur_BalanceCC_Recibos_Varios INTO @Id_Trans, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	END
	CLOSE cur_BalanceCC_Recibos_Varios
	DEALLOCATE cur_BalanceCC_Recibos_Varios
	
	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Recibos Clientes'
	END

	CREATE TABLE #Rpt_BalanceCC_Recibos_Clientes
	(
	Id_Trans_Aplica					INT,
	Importe							DECIMAL(12,2),
	Imp_Total_Fac					DECIMAL(12,2),
	Id_Trans_CCC					INT,
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Fecha_Rec						DATETIME,
	Descripcion						VARCHAR(80),
	Destinatario					VARCHAR(100),
	Observacion_Orig				VARCHAR(8000),
	Observacion_Dest				VARCHAR(8000)
	)
	
	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_BalanceCC_Recibos_Clientes (Id_Trans_Aplica, Importe, Imp_Total_Fac, Id_Trans_CCC, Alias, Nro_Cta_Contable, Debe, Haber, Fecha_Rec, Descripcion, Destinatario, Observacion_Orig, Observacion_Dest) '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))							+ CHAR(13) + 
					'SELECT '										+ CHAR(13) + 
					'A.Id_Trans, '									+ CHAR(13) + 
					'A.Importe, '									+ CHAR(13) + 
					'Fac.Imp_Total, '								+ CHAR(13) + 
					'C.Id_Trans, '									+ CHAR(13) + 
					'O.Alias, '										+ CHAR(13) + 
					'O.Nro_Cta_Contable, '							+ CHAR(13) + 
					'C.Debe, '										+ CHAR(13) + 
					'C.Haber, '										+ CHAR(13) + 
					'Rec.Fecha, '									+ CHAR(13) + 
					'O.Descripcion, '								+ CHAR(13) + 
					'ISNULL(Fac.Destinatario, '''') AS Destinatario, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), Fac.Observacion), '''') AS Observacion_Orig, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), Rec.Observacion), '''') AS Observacion_Dest '+ CHAR(13) +
					'FROM Cbtes_Aplica A, Cbtes_Ctas_Contables C, Cbtes Rec,Cbtes Fac,Cbtes_Tipos T,Pla_Ctas_Cuentas_Contables O ' + CHAR(13) + 
					'WHERE '										+ CHAR(13) + 
					'C.id_trans = A.id_trans '						+ CHAR(13) + 
					'AND A.id_trans_D = Rec.id_trans '				+ CHAR(13) + 
					'AND Fac.id_trans = C.id_trans '				+ CHAR(13) + 
					'AND Rec.id_Tipo_Cbte = T.Id_Tipo_Cbte '		+ CHAR(13) + 
					'AND O.Id_Cta_Contable = C.Id_Cta_Contable '	+ CHAR(13) + 
					'AND Rec.Id_Cliente > 0 '						+ CHAR(13) + 
					'AND Rec.Id_Estado_Cbte NOT IN (0,3) '			+ CHAR(13) + 
					'AND Fac.Id_Estado_Cbte NOT IN (0,3) ' 


	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND Rec.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND Rec.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND C.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND T.Compromete_Recibos IN (1,-1)'

	IF(@pSoloResultado = 1)
	BEGIN
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND ISNULL(O.Tipo, '''') IN (''+'',''-'') '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr (Recibos Clientes): '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	/*=============================================================================================================================*/

	DECLARE cur_BalanceCC_Recibos_Clientes CURSOR FOR
	SELECT 
	Id_Trans_Aplica,
	Id_Trans_CCC,
	Importe,
	Imp_Total_Fac,
	Alias,
	Nro_Cta_Contable, 
	Debe, 
	Haber, 
	Fecha_Rec, 
	Descripcion,
	Destinatario,
	Observacion_Orig,
	Observacion_Dest
	FROM #Rpt_BalanceCC_Recibos_Clientes

	OPEN cur_BalanceCC_Recibos_Clientes
	FETCH NEXT FROM cur_BalanceCC_Recibos_Clientes INTO @Id_Trans, @Id_Trans_CCC, @Importe, @Imp_Total_Fac, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	WHILE @@FETCH_STATUS = 0
	BEGIN

		SET @Imp_Aplicado	= @Importe
		SET @Imp_Fac		= @Imp_Total_Fac
		SET @Coef_Aplic		= @Imp_Aplicado / @Imp_Fac

		INSERT INTO #Rpt_BalanceCC
		(Id_Trans_O,
		Id_Trans_D,
		Alias,
		Nro_Cta_Contable,
		Debe,
		Haber,
		Saldo,
		Fecha,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Centro_Costo2,
		Centro_Costo3,
		Destinatario,
		Observacion_Orig,
		Observacion_Dest)
		VALUES
		(@Id_Trans_CCC,
		@Id_Trans,
		@Alias,
		@Nro_Cta_Contable,
		@Debe * @Coef_Aplic,
		@Haber * @Coef_Aplic,
		0,
		@Fecha,
		@Descripcion,
		@pId_Centro_Costo,
		@Centro_Costo,
		@Centro_Costo_Padre1,
		@Centro_Costo_Padre2,
		@Destinatario,
		@Observacion_Orig,
		@Observacion_Dest)

		FETCH NEXT FROM cur_BalanceCC_Recibos_Clientes INTO @Id_Trans, @Id_Trans_CCC, @Importe, @Imp_Total_Fac, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	END
	CLOSE cur_BalanceCC_Recibos_Clientes
	DEALLOCATE cur_BalanceCC_Recibos_Clientes

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Recibos OP Varias'
	END

	CREATE TABLE #Rpt_BalanceCC_OP_Varias
	(
	Id_Trans						INT,
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Fecha							DATETIME,
	Descripcion						VARCHAR(80),
	Destinatario					VARCHAR(100),
	Observacion_Orig				VARCHAR(8000),
	Observacion_Dest				VARCHAR(8000)
	)
	
	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_BalanceCC_OP_Varias (Id_Trans, Alias, Nro_Cta_Contable, Debe, Haber, Fecha, Descripcion, Destinatario, Observacion_Orig, Observacion_Dest) '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))							+ CHAR(13) + 
					'SELECT '										+ CHAR(13) + 
					'C.Id_Trans, '									+ CHAR(13) + 
					'O.Alias, '										+ CHAR(13) + 
					'O.Nro_Cta_Contable, '							+ CHAR(13) + 
					'C.Debe, '										+ CHAR(13) + 
					'C.Haber, '										+ CHAR(13) + 
					'E.Fecha, '										+ CHAR(13) + 
					'O.Descripcion AS Cta_Contable, '				+ CHAR(13) + 
					'ISNULL(E.Destinatario, '''') AS Destinatario, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), E.Observacion), '''') AS Observacion_Orig, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), E.Observacion), '''') AS Observacion_Dest '+ CHAR(13) +
					'FROM Cbtes_Ctas_Contables C, Cbtes E,Cbtes_Tipos T,Pla_Ctas_Cuentas_Contables O ' + CHAR(13) + 
					'WHERE '										+ CHAR(13) + 
					'C.Id_Trans = E.Id_Trans '						+ CHAR(13) + 
					'AND E.Id_Tipo_Cbte = T.Id_Tipo_Cbte '			+ CHAR(13) + 	
					'AND O.Id_Cta_Contable = C.Id_Cta_Contable '	+ CHAR(13) +
					'AND ISNULL(E.Id_Proveedor, 0) = 0 '			+ CHAR(13) + 					
					'AND E.Id_Estado_Cbte NOT IN (0,3) '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND E.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND E.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND C.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND T.Compromete_Pagos IN (1,-1)'

	IF(@pSoloResultado = 1)
	BEGIN
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND ISNULL(O.Tipo, '''') IN (''+'',''-'') '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr (Orden Pagos Varias): '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	/*=============================================================================================================================*/

	DECLARE cur_BalanceCC_OP_Varias CURSOR FOR
	SELECT 
	Id_Trans,
	Alias,
	Nro_Cta_Contable, 
	Debe, 
	Haber, 
	Fecha, 
	Descripcion,
	Destinatario,
	Observacion_Orig,
	Observacion_Dest
	FROM #Rpt_BalanceCC_OP_Varias

	OPEN cur_BalanceCC_OP_Varias
	FETCH NEXT FROM cur_BalanceCC_OP_Varias INTO @Id_Trans, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	WHILE @@FETCH_STATUS = 0
	BEGIN

		INSERT INTO #Rpt_BalanceCC
		(Id_Trans_O,
		Id_Trans_D,
		Alias,
		Nro_Cta_Contable,
		Debe,
		Haber,
		Saldo,
		Fecha,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Centro_Costo2,
		Centro_Costo3,
		Destinatario,
		Observacion_Orig,
		Observacion_Dest)
		VALUES
		(@Id_Trans,
		0,
		@Alias,
		@Nro_Cta_Contable,
		@Debe,
		@Haber,
		0,
		@Fecha,
		@Descripcion,
		@pId_Centro_Costo,
		@Centro_Costo,
		@Centro_Costo_Padre1,
		@Centro_Costo_Padre2,
		@Destinatario,
		@Observacion_Orig,
		@Observacion_Dest)		

		FETCH NEXT FROM cur_BalanceCC_OP_Varias INTO @Id_Trans, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	END
	CLOSE cur_BalanceCC_OP_Varias
	DEALLOCATE cur_BalanceCC_OP_Varias

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'OP Proveedores'
	END

	CREATE TABLE #Rpt_BalanceCC_OP_Proveedores
	(
	Id_Trans_Aplica					INT,
	Importe							DECIMAL(12,2),
	Imp_Total_Fac					DECIMAL(12,2),
	Id_Trans_CCC					INT,
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Fecha_OP						DATETIME,
	Descripcion						VARCHAR(80),
	Destinatario					VARCHAR(100),
	Observacion_Orig				VARCHAR(8000),
	Observacion_Dest				VARCHAR(8000)
	)
	
	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_BalanceCC_OP_Proveedores (Id_Trans_Aplica, Importe, Imp_Total_Fac, Id_Trans_CCC, Alias, Nro_Cta_Contable, Debe, Haber, Fecha_OP, Descripcion, Destinatario, Observacion_Orig, Observacion_Dest) '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))							+ CHAR(13) + 
					'SELECT '										+ CHAR(13) + 
					'A.Id_Trans, '									+ CHAR(13) + 
					'A.Importe, '									+ CHAR(13) + 
					'Fac.Imp_Total, '								+ CHAR(13) + 
					'OP.Id_Trans, '									+ CHAR(13) + 
					'O.Alias, '										+ CHAR(13) +
					'O.Nro_Cta_Contable, '							+ CHAR(13) + 
					'C.Debe, '										+ CHAR(13) + 
					'C.Haber, '										+ CHAR(13) + 
					'OP.Fecha, '									+ CHAR(13) + 
					'O.Descripcion, '								+ CHAR(13) + 
					'ISNULL(Fac.Destinatario, '''') AS Destinatario, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), Fac.Observacion), '''') AS Observacion_Orig, '+ CHAR(13) + 
					'ISNULL(CONVERT(VARCHAR(8000), OP.Observacion), '''') AS Observacion_Dest '+ CHAR(13) +
					'FROM Cbtes_Aplica A,Cbtes_Ctas_Contables C, Cbtes OP,Cbtes Fac,Cbtes_Tipos T,Pla_Ctas_Cuentas_Contables O ' + CHAR(13) + 
					'WHERE '										+ CHAR(13) + 
					'C.id_trans = A.id_trans '						+ CHAR(13) + 
					'AND A.id_trans_D = OP.id_trans '				+ CHAR(13) + 
					'AND Fac.id_trans = C.id_trans '				+ CHAR(13) + 
					'AND OP.id_Tipo_Cbte = T.Id_Tipo_Cbte '			+ CHAR(13) + 
					'AND O.Id_Cta_Contable = C.Id_Cta_Contable '	+ CHAR(13) + 
					'AND OP.Id_Proveedor > 0 '						+ CHAR(13) + 
					'AND OP.Id_Estado_Cbte NOT IN (0,3) '			+ CHAR(13) + 
					'AND Fac.Id_Estado_Cbte NOT IN (0,3) ' 


	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND OP.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND OP.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND C.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND T.Compromete_Pagos IN (1,-1)'

	IF(@pSoloResultado = 1)
	BEGIN
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND ISNULL(O.Tipo, '''') IN (''+'',''-'') '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr (OP Proveedores): '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	/*=============================================================================================================================*/

	DECLARE cur_BalanceCC_OP_Proveedores CURSOR FOR
	SELECT 
	Id_Trans_Aplica,
	Id_Trans_CCC,
	Importe,
	Imp_Total_Fac,
	Alias,
	Nro_Cta_Contable, 
	Debe, 
	Haber, 
	Fecha_OP, 
	Descripcion,
	Destinatario,
	Observacion_Orig,
	Observacion_Dest	
	FROM #Rpt_BalanceCC_OP_Proveedores

	OPEN cur_BalanceCC_OP_Proveedores
	FETCH NEXT FROM cur_BalanceCC_OP_Proveedores INTO @Id_Trans, @Id_Trans_CCC, @Importe, @Imp_Total_Fac, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	WHILE @@FETCH_STATUS = 0
	BEGIN

		SET @Imp_Aplicado	= @Importe
		SET @Imp_Fac		= @Imp_Total_Fac
		SET @Coef_Aplic		= @Imp_Aplicado / @Imp_Fac

		INSERT INTO #Rpt_BalanceCC
		(Id_Trans_O,
		Id_Trans_D,
		Alias,
		Nro_Cta_Contable,
		Debe,
		Haber,
		Saldo,
		Fecha,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Centro_Costo2,
		Centro_Costo3,
		Destinatario,
		Observacion_Orig,
		Observacion_Dest)
		VALUES
		(@Id_Trans_CCC,
		@Id_Trans,
		@Alias,
		@Nro_Cta_Contable,
		@Debe * @Coef_Aplic,
		@Haber * @Coef_Aplic,
		0,
		@Fecha,
		@Descripcion,
		@pId_Centro_Costo,
		@Centro_Costo,
		@Centro_Costo_Padre1,
		@Centro_Costo_Padre2,
		@Destinatario,
		@Observacion_Orig,
		@Observacion_Dest)

		FETCH NEXT FROM cur_BalanceCC_OP_Proveedores INTO @Id_Trans, @Id_Trans_CCC, @Importe, @Imp_Total_Fac, @Alias, @Nro_Cta_Contable, @Debe, @Haber, @Fecha, @Descripcion, @Destinatario, @Observacion_Orig, @Observacion_Dest
	END
	CLOSE cur_BalanceCC_OP_Proveedores
	DEALLOCATE cur_BalanceCC_OP_Proveedores

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Asientos Manuales'
	END

	CREATE TABLE #Rpt_BalanceCC_AS_Manuales
	(
	Alias							DECIMAL(12,0),
	Nro_Cta_Contable				VARCHAR(20),
	Descripcion						VARCHAR(80),
	Fecha							DATETIME,	
	Destinatario					VARCHAR(100),
	Debe							DECIMAL(12,2),
	Haber							DECIMAL(12,2),
	Observacion						VARCHAR(8000)
	)

	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_BalanceCC_AS_Manuales (Alias, Nro_Cta_Contable, Descripcion, Fecha, Destinatario, Debe, Haber, Observacion) '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))							+ CHAR(13) + 
					'SELECT '										+ CHAR(13) + 
					'PCCC.Alias AS Alias, '							+ CHAR(13) + 
					'PCCC.Nro_Cta_Contable AS Nro_Cta, '			+ CHAR(13) + 
					'PCCC.Descripcion AS Cta, '						+ CHAR(13) + 
					'A.Fecha AS Fecha, '							+ CHAR(13) + 
					'A.Descripcion AS Destinatario, '				+ CHAR(13) + 
					'AI.Debe, '										+ CHAR(13) + 
					'AI.Haber, '									+ CHAR(13) + 
					'AI.Nota '										+ CHAR(13) + 
					'FROM Asientos A, Asientos_Items AI, Pla_Ctas_Cuentas_Contables PCCC ' + CHAR(13) + 
					'WHERE '										+ CHAR(13) + 
					'A.Id_Asiento = AI.Id_Asiento '					+ CHAR(13) + 
					'AND AI.Id_Cta_Contable = PCCC.Id_Cta_Contable '+ CHAR(13) + 
					'AND ISNULL(A.Resumido, 0) = 0 '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha >= ''' + CONVERT(VARCHAR(10), @pFecha_Desde, 112) + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND A.Fecha < ''' + CONVERT(VARCHAR(10), DATEADD(DAY, 1, @pFecha_Hasta), 112) + ''' '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND AI.Id_Centro_Costo = ''' + @pId_Centro_Costo + ''' '
					
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'AND AI.Id_Alias_Cta_Cont = ' + CONVERT(VARCHAR(10), @pId_Alias_Cta_Cont)

	IF(@pSoloResultado = 1)
	BEGIN
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'AND ISNULL(PCCC.Tipo, '''') IN (''+'',''-'') '
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr (AS Manuales): '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr

	/*=============================================================================================================================*/

	DECLARE cur_BalanceCC_AS_Manuales CURSOR FOR
	SELECT 
	Alias,
	Nro_Cta_Contable,
	Descripcion,
	Fecha,
	Destinatario,
	Debe,
	Haber,
	Observacion
	FROM #Rpt_BalanceCC_AS_Manuales

	OPEN cur_BalanceCC_AS_Manuales
	FETCH NEXT FROM cur_BalanceCC_AS_Manuales INTO @Alias, @Nro_Cta_Contable, @Descripcion, @Fecha, @Destinatario, @Debe, @Haber, @Observacion_Orig
	WHILE @@FETCH_STATUS = 0
	BEGIN

		SET @Imp_Aplicado	= 0
		SET @Imp_Fac		= 0
		SET @Coef_Aplic		= 0

		INSERT INTO #Rpt_BalanceCC
		(Id_Trans_O,
		Id_Trans_D,
		Alias,
		Nro_Cta_Contable,
		Debe,
		Haber,
		Saldo,
		Fecha,
		Cta_Contable,
		Id_Centro_Costo,
		Centro_Costo,
		Centro_Costo2,
		Centro_Costo3,
		Destinatario,
		Observacion_Orig,
		Observacion_Dest)
		VALUES
		(0,
		0,
		@Alias,
		@Nro_Cta_Contable,
		@Debe,
		@Haber,
		0,
		@Fecha,
		@Descripcion,
		@pId_Centro_Costo,
		@Centro_Costo,
		@Centro_Costo_Padre1,
		@Centro_Costo_Padre2,
		@Destinatario,
		@Observacion_Orig,
		'')

		FETCH NEXT FROM cur_BalanceCC_AS_Manuales INTO @Alias, @Nro_Cta_Contable, @Descripcion, @Fecha, @Destinatario, @Debe, @Haber, @Observacion_Orig
	END
	CLOSE cur_BalanceCC_AS_Manuales
	DEALLOCATE cur_BalanceCC_AS_Manuales

	/*=============================================================================================================================*/
	/*=============================================================================================================================*/
	
	--Explosion por Cbtes
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Explosion por Comprobantes'
	END
	/*
	SELECT
	Centro_Costo AS CC1, 
	Centro_Costo2 AS CC2,
	Centro_Costo3 AS CC3,
	Nro_Cta_Contable AS Nro_Cta, 
	Cta_Contable AS Cta,
	Id_Trans_O AS Trans_Origen,
	CONVERT(DATE, Fecha) AS Fecha,
	dbo.CF_Cbte_Descrip(Id_Trans_O) AS Cbte,
	Destinatario AS Destinatario,
	Observacion_Orig AS Obs,
	Id_Trans_D AS Trans_Destino,
	'' AS Fecha_Destino,
	dbo.CF_Cbte_Descrip(Id_Trans_D) AS Cbte_Destino,
	Observacion_Dest AS Obs_Destino,
	Debe,
	Haber,
	Saldo
	FROM #Rpt_BalanceCC
	ORDER BY Nro_Cta_Contable, Fecha
	*/
	
	/*=============================================================================================================================*/
	/*=============================================================================================================================*/
	
	--Agrupacion por Cuentas Mensual
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Agrupacion por Cuentas Mensual'
	END

	/*=============================================================================================================================*/
	
	CREATE TABLE #Rpt_Balance_Financiero_Saldo_x_Mes_CC_Meses
	(Mes			TINYINT,
	Desde			DATETIME,
	Hasta			DATETIME)

	SET @Mes_Nro = 1
	SET @Mes_Desde = dbo.CF_FOMONTH(@pFecha_Desde)
	SET @Mes_Hasta = dbo.CF_EOMONTH(@pFecha_Desde)

	WHILE @Mes_Hasta <= @pFecha_Hasta
	BEGIN
		IF(@pModoDebug = 1)
		BEGIN
			PRINT '@Mes_Nro: ' + CONVERT(VARCHAR(10), @Mes_Nro) + '. @Mes_Desde: ' + CONVERT(VARCHAR(10), @Mes_Desde, 112) + '. @Mes_Hasta: ' + CONVERT(VARCHAR(10), @Mes_Hasta, 112)
		END

		INSERT INTO #Rpt_Balance_Financiero_Saldo_x_Mes_CC_Meses
		(Mes,	Desde,	Hasta)
		VALUES
		(@Mes_Nro, @Mes_Desde, @Mes_Hasta)

		SET @Mes_Nro = @Mes_Nro + 1
		SET @Mes_Desde = DATEADD(MONTH, 1, @Mes_Desde)
		SET @Mes_Hasta = dbo.CF_EOMONTH(@Mes_Desde)	
	END

	/*=============================================================================================================================*/
	
	CREATE TABLE #Rpt_Balance_Financiero_Saldo_x_Mes_CC
	(Nro_Cta_Contable				VARCHAR(20),
	Alias							DECIMAL(12,0),
	Cta_Contable					VARCHAR(80),
	Id_Centro_Costo					CHAR(10),
	Centro_Costo					VARCHAR(200),
	Mes_01							DECIMAL(16,2),
	Mes_02							DECIMAL(16,2),
	Mes_03							DECIMAL(16,2),
	Mes_04							DECIMAL(16,2),
	Mes_05							DECIMAL(16,2),
	Mes_06							DECIMAL(16,2),
	Mes_07							DECIMAL(16,2),
	Mes_08							DECIMAL(16,2),
	Mes_09							DECIMAL(16,2),
	Mes_10							DECIMAL(16,2),
	Mes_11							DECIMAL(16,2),
	Mes_12							DECIMAL(16,2),
	Total							DECIMAL(16,2))
	
	/*=============================================================================================================================*/

	SET @SqlStr =	'INSERT INTO #Rpt_Balance_Financiero_Saldo_x_Mes_CC (Alias, Nro_Cta_Contable, Cta_Contable, Id_Centro_Costo, Centro_Costo) '
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) + 
					'SELECT DISTINCT Alias, Nro_Cta_Contable, Cta_Contable, Id_Centro_Costo, Centro_Costo '

	SET @SqlStr =	RTRIM(LTRIM(@SqlStr)) + CHAR(13) +
					'FROM #Rpt_BalanceCC '

	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT '@SqlStr: '
		PRINT @SqlStr
		PRINT ''
	END

	EXECUTE sp_executesql @SqlStr
	
	/*=============================================================================================================================*/

	UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC 
	SET 
	Mes_01 = 0,
	Mes_02 = 0,
	Mes_03 = 0,
	Mes_04 = 0,
	Mes_05 = 0,
	Mes_06 = 0,
	Mes_07 = 0,
	Mes_08 = 0,
	Mes_09 = 0,
	Mes_10 = 0,
	Mes_11 = 0,
	Mes_12 = 0,
	Total = 0
	
	/*=============================================================================================================================*/

	DECLARE curCPJ_BalanceSaldoMesCentro_Rpt CURSOR FOR
	SELECT 
	Alias, 
	Id_Centro_Costo 
	FROM #Rpt_Balance_Financiero_Saldo_x_Mes_CC

	OPEN curCPJ_BalanceSaldoMesCentro_Rpt
	FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo
	WHILE @@FETCH_STATUS = 0
	BEGIN

		--Recorro todos los meses
		DECLARE curCPJ_BalanceSaldoMesCentro_Rpt_Meses CURSOR FOR
		SELECT Mes, Desde, Hasta 
		FROM #Rpt_Balance_Financiero_Saldo_x_Mes_CC_Meses
		ORDER BY Mes

		OPEN curCPJ_BalanceSaldoMesCentro_Rpt_Meses
		FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt_Meses INTO @Mes_Nro, @Mes_Desde, @Mes_Hasta
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @Suma_Debe =	ISNULL((SELECT SUM(Debe) 
											FROM #Rpt_BalanceCC 
											WHERE 
											Alias = @Alias
											AND Id_Centro_Costo = @Id_Centro_Costo
											AND CONVERT(DATE, Fecha) >= CONVERT(DATE, @Mes_Desde)
											AND CONVERT(DATE, Fecha) < DATEADD(DAY, 1, CONVERT(DATE, @Mes_Hasta)))
											, 0)

			SET @Suma_Haber =	ISNULL((SELECT SUM(Haber) 
											FROM #Rpt_BalanceCC 
											WHERE 
											Alias = @Alias
											AND Id_Centro_Costo = @Id_Centro_Costo
											AND CONVERT(DATE, Fecha) >= CONVERT(DATE, @Mes_Desde)
											AND CONVERT(DATE, Fecha) < DATEADD(DAY, 1, CONVERT(DATE, @Mes_Hasta)))
											, 0)

			SET @Suma_Saldo = @Suma_Debe - @Suma_Haber

			IF(@pModoDebug = 1)
			BEGIN
				PRINT '@Alias: ' + CONVERT(VARCHAR(10), @Alias) + '. @Centro_Costo: ' + LTRIM(RTRIM(CONVERT(VARCHAR(10), @Id_Centro_Costo))) + '. @pId_Plan_Cta: ' + CONVERT(VARCHAR(10), @pId_Plan_Cta) + '. @pId_Unid_Negocio: ' + LTRIM(RTRIM(CONVERT(VARCHAR(10), @pId_Unid_Negocio))) + '. @Mes_Nro: ' + CONVERT(VARCHAR(10), @Mes_Nro) + ' (@Mes_Desde: ' + CONVERT(VARCHAR(10), @Mes_Desde, 112) + ' - @Mes_Hasta: ' + CONVERT(VARCHAR(10), @Mes_Hasta, 112) + '). @Suma_Debe: ' + CONVERT(VARCHAR(20), @Suma_Debe) + '. @Suma_Haber: ' + CONVERT(VARCHAR(20), @Suma_Haber) + '. @Suma_Saldo: ' + CONVERT(VARCHAR(20), @Suma_Saldo)
			END

			IF(@Mes_Nro = 1)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_01 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo				
			END

			IF(@Mes_Nro = 2)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_02 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 3)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_03 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 4)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_04 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 5)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_05 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 6)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_06 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 7)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_07 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 8)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_08 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 9)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_09 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 10)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_10 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 11)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_11 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			IF(@Mes_Nro = 12)
			BEGIN
				UPDATE #Rpt_Balance_Financiero_Saldo_x_Mes_CC SET Mes_12 = @Suma_Saldo WHERE Alias = @Alias AND Id_Centro_Costo = @Id_Centro_Costo
			END

			FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt_Meses INTO @Mes_Nro, @Mes_Desde, @Mes_Hasta
		END
		CLOSE curCPJ_BalanceSaldoMesCentro_Rpt_Meses
		DEALLOCATE curCPJ_BalanceSaldoMesCentro_Rpt_Meses	

		FETCH NEXT FROM curCPJ_BalanceSaldoMesCentro_Rpt INTO @Alias, @Id_Centro_Costo
	END
	CLOSE curCPJ_BalanceSaldoMesCentro_Rpt
	DEALLOCATE curCPJ_BalanceSaldoMesCentro_Rpt
	
	/*=============================================================================================================================*/

	SELECT * FROM #Rpt_Balance_Financiero_Saldo_x_Mes_CC
	
	
	/*=============================================================================================================================*/
	/*=============================================================================================================================*/
	
	DROP TABLE #Rpt_BalanceCC_Recibos_Varios
	DROP TABLE #Rpt_BalanceCC_Recibos_Clientes
	DROP TABLE #Rpt_BalanceCC_OP_Varias
	DROP TABLE #Rpt_BalanceCC_OP_Proveedores
	DROP TABLE #Rpt_BalanceCC
	DROP TABLE #Rpt_BalanceCC_AS_Manuales
	DROP TABLE #Rpt_Balance_Financiero_Saldo_x_Mes_CC_Meses
	DROP TABLE #Rpt_Balance_Financiero_Saldo_x_Mes_CC
	
	/*=============================================================================================================================*/
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_BalanceCC_Rpt'
	END
END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0

/*
EXEC dbo.CPJ_BalanceCC_Rpt '{
							"ModoDebug":"1",
							"Id_Usuario":"-1",
							"Fecha_Desde":"20210101",
							"Fecha_Hasta":"20211231",
							"Id_Centro_Costo":"1",
							"Id_Alias_Cta_Cont":"140",
							"SoloResultado":"1"
							}'
*/
